<?php
/**
 # ------------------------------------------------------------------------
 * JWeb Portfolio Display
 # ------------------------------------------------------------------------
 * @package      mod_jweb_portfolio_display
 * @version      1.0
 * @created      October 2015
 * @author       Joomla Web Build
 * @email        admin@joomlawebbuild.com
 * @websites     http://joomlawebbuild.com
 * @copyright    Copyright (C) 2015 Joomla Web Build. All rights reserved.
 * @license      GNU General Public License version 2, or later
 # ------------------------------------------------------------------------
**/

defined( '_JEXEC' ) or die( 'Restricted access' );

class modJWEBPortfolioHelper {
	/**
     * load javascript files: processing override js, load js compress or not.
     */
    public static function loadJS($params)
    {
		$document = JFactory::getDocument();
		$enable_jquery = $params->get('enable_jquery', 1);
		$enable_noconflict = $params->get('enable_noconflict', 1);
		JHtml::_('jquery.framework');
		$document->addScript(JURI::base() . 'modules/mod_jweb_portfolio_display/assets/js/isotope.pkgd.min.js');
		$document->addScript(JURI::base() . 'modules/mod_jweb_portfolio_display/assets/js/imagesloaded.pkgd.min.js');
		$document->addScript(JURI::base() . 'modules/mod_jweb_portfolio_display/assets/js/jquery.magnific-popup.js');
    }

    /**
     * load javascript files: processing override js, load js compress or not.
     */
    public static function loadCSS($params)
    {
		$document = JFactory::getDocument();
		$document->addStyleSheet(JURI::base() . 'modules/mod_jweb_portfolio_display/assets/css/style.css');
		$document->addStyleSheet(JURI::base() . 'modules/mod_jweb_portfolio_display/assets/css/hover2.css');
		$document->addStyleSheet(JURI::base() . 'modules/mod_jweb_portfolio_display/assets/css/magnific-popup.css');
		$document->addStyleSheet(JURI::base() . 'modules/mod_jweb_portfolio_display/assets/css/lightbox.css');
    }

    public static function getImagesFolder($params){
    	// Get images gallery for portfolio
		$slidePath = $params->get('folder.folder','');
		$slides = array();
		$slide = array();
		if (($images = $params->get('folder.images','')))
		{
		    $slides = json_decode($images);
		}
		// Ordering Slider
		foreach ($slides as $position)
		{
		    $slide[$position->position] = $position;
		}
		ksort($slide);
		// var_dump($slide);
		// $tags = array();
		foreach ($slide as $item) {
			if($item->tags == ""){
				$tags = JText::_("JWEB_PORTFOLIO_NO_TAG");
			}
			else{
				$tags = preg_replace('/\s+/', '', $item->tags);
			}
			$item->tags = explode(',', $tags);
		}
		
		return $slide;
    }

    public static function limit_words($string="", $word_limit="")
	{
	    $words = preg_split('/\s+/', $string);
	    return implode(" ",array_splice($words,0,$word_limit))."...";
	}
	/*
	 * Convert Hex to RBG
	 * $return Params String rgba('$rbg,$opacity')
	 */
	public static function jwebHex2rgb($bgColor){
		$color		= str_replace("#",'',$bgColor);
		if(strlen($color) == 3) {
			$r = hexdec(substr($color,0,1).substr($color,0,1));
			$g = hexdec(substr($color,1,1).substr($color,1,1));
			$b = hexdec(substr($color,2,1).substr($color,2,1));
		 } else {
			$r = hexdec(substr($color,0,2));
			$g = hexdec(substr($color,2,2));
			$b = hexdec(substr($color,4,2));
		 }
		 // return value color rgb(r,g,b,opacity)
		$rgb = $r .','. $g .','.$b;
		return $rgb;
	}

	/*
	 * Method to check browsers
	 */
	public static function jwebPortfolioGetBrowser()
	{
		$u_agent = $_SERVER['HTTP_USER_AGENT'];
		$bname = 'Unknown';					
		// Next get the name of the useragent yes seperately and for good reason
		if(preg_match('/MSIE/i',$u_agent) || preg_match('/Trident/i',$u_agent) && !preg_match('/Opera/i',$u_agent))
		{
			$bname = 'Internet Explorer';
			$ub = "MSIE";
		}
		elseif(preg_match('/Firefox/i',$u_agent))
		{
			$bname = 'Mozilla Firefox';
			$ub = "Firefox";
		}
		elseif(preg_match('/Chrome/i',$u_agent) && !preg_match('/OPR/i',$u_agent))
		{
			$bname = 'Google Chrome';
			$ub = "Chrome";
		}
		elseif(preg_match('/Safari/i',$u_agent) && !preg_match('/OPR/i',$u_agent))
		{
			$bname = 'Apple Safari';
			$ub = "Safari";
		}
		elseif(preg_match('/Opera/i',$u_agent) || preg_match('/OPR/i',$u_agent) )
		{
			$bname = 'Opera';
			$ub = "Opera";
		}
		elseif(preg_match('/Netscape/i',$u_agent))
		{
			$bname = 'Netscape';
			$ub = "Netscape";
		}
		return array(					
			'name'      => $bname		
		);
	}
}